#ifndef __PNM_APPLICATION_H
#define __PNM_APPLICATION_H

#include "TLR_Types.h"
#include "TLR_Packet.h"

#include "Application.h"

#include "TLR_Results.h"

#include "PNM_PNIOAPCFG_Public.h"
#include "PNM_PNIOAPCTL_Public.h"

#include "rcX_Public.h"

#include <malloc.h>

#ifdef __cplusplus
  extern "C" {
#endif  /* _cplusplus */



/* the size of the real-time-data in byte*/
#define MAX_RTD_SIZE         (16)
/* amount of IO-Devices for which resources are allocated */
#define IO_DEVICE_COUNT      (2)
/* amount of submodules per IO-Device for which resources are allocated */
#define MAX_SUBMODULE_COUNT  (32)


/* parameters required to configure a submodule */
typedef struct
{
  TLR_UINT32 ulApi;
  TLR_UINT16 usSlot;
  TLR_UINT16 usSubslot;
  TLR_UINT32 ulModuleId;
  TLR_UINT32 ulSubmodId;
  TLR_UINT16 usDPMOffsIn;
  TLR_UINT16 usDPMOffsOut;
  TLR_UINT16 usInputLength;
  TLR_UINT16 usOutputLength;
  TLR_UINT16 usLenRecord;
  TLR_UINT8* pbRecordData;
} PNM_SUBMODULE_T;

/* parameters required to configure an IO-Device */
typedef struct
{
  TLR_UINT32 ulIpAddr;
  TLR_UINT32 ulNetmask;
  TLR_UINT32 ulGateway;
  TLR_UINT16 usVendorId;
  TLR_UINT16 usDeviceId;
  TLR_UINT16 usInstance;     /* from GSDML */
  TLR_UINT8  abNameOfStation[240];
  TLR_UINT32 ulArUuid1;
  TLR_UINT16 usArUuid2;
  TLR_UINT16 usArUuid3;
  TLR_UINT8  abArUuid4[8];
  TLR_UINT16 usSendClock;
  TLR_UINT16 usReductRatio;

  /* the amount of submodules */
  TLR_UINT16       usSubmodCnt;
  /* the submodules */
  PNM_SUBMODULE_T* patSubm;
} PNM_IO_DEVICE_PARAMETERS_T;


/*************************************************************************************************
 * @brief This structure contains all bus specific specific application data.
 *
 */
typedef struct PNM_APPLICATION_EXTENDED_Ttag
{
  /* amount of IO-Devices in configuration */
  TLR_UINT16 usIoDeviceCount;
  /* IO-Device parameters */
  PNM_IO_DEVICE_PARAMETERS_T* patIoDevices;

} PNM_APPLICATION_EXTENDED_T;



/*************************************************************************************************
 * @brief This structure contains all application data.
 * It combines the common application data and the bus specific application data.
 */
typedef struct PNM_APPLICATION_Ttag
{
  APPLICATION_COMMON_T       tCommon;
  PNM_APPLICATION_EXTENDED_T tPnm;
} PNM_APPLICATION_T;


/***************************************************************************************/

#ifdef __cplusplus
  }
#endif  /* _cplusplus */


#endif /* #ifndef __PNM_APPLICATION_H */
